﻿using UnityEngine;
using UnityEngine.Events;


public class ProjectileHit {
	public Vector3 point;
	public Vector3 normal;
	public Collider collider;

	public ProjectileHit() {}

	public ProjectileHit(Vector3 point, Vector3 normal, Collider collider) {
		this.point = point;
		this.normal = normal;
		this.collider = collider;
	}
}

public class ProjectileBase : MonoBehaviour
{

    public WeaponController weapon { get; private set; }
    public GameObject owner { get; private set; }
    public Vector3 initialPosition { get; private set; }
    public Vector3 initialDirection { get; private set; }
    public Vector3 inheritedMuzzleVelocity { get; private set; }
    public float initialCharge { get; private set; }

    public UnityAction onShoot;

    public void Shoot(WeaponController controller)
    {
        weapon = controller;
        owner = weapon.owner;
        initialPosition = transform.position;
        initialDirection = transform.forward;
        inheritedMuzzleVelocity = weapon.muzzleWorldVelocity;
        initialCharge = weapon.currentCharge;

        if (onShoot != null)
        {
            onShoot.Invoke();
        }
    }
}
