using UnityEngine;
using UnityEngine.Events;

namespace MIGames.FPS.Props {
	public class Switch : MonoBehaviour {
		public bool activated;

		public string messageActivate;
		public string messageDeactivate;
		public string messageSwitchState = "OnSwitchState";

		public UnityEvent onSwitchOn;
		public UnityEvent onSwitchOff;

		public UnityAction onActivate;
		public UnityAction onDeactivate;
		public UnityAction<bool> onSwitchState;

		protected Animator animator;

		protected bool isActive = false;

		void OnEnable() {
			this.animator = GetComponent<Animator>();

			SetActive(this.activated);
		}

		void Update() {
			if(this.activated != this.isActive) {
				SetActive(this.activated);
			}
		}

		void OnInteract(GameObject source) {
			SetActive(!this.isActive);
		}

		protected void SetActive(bool active) {
			if(this.animator != null) this.animator.SetBool("Active", active);
			
			if(this.onSwitchState != null) this.onSwitchState.Invoke(active);
			if(active) {
				if(this.onActivate != null) this.onActivate.Invoke();
				if(this.onSwitchOn != null) this.onSwitchOn.Invoke();
			} else {
				if(this.onDeactivate != null) this.onDeactivate.Invoke();
				if(this.onSwitchOff != null) this.onSwitchOff.Invoke();
			}

			if(!string.IsNullOrEmpty(this.messageSwitchState)) SendMessage(this.messageSwitchState, active, SendMessageOptions.DontRequireReceiver);
			if(active) {
				if(!string.IsNullOrEmpty(this.messageActivate)) SendMessage(this.messageActivate, SendMessageOptions.DontRequireReceiver);
			} else {
				if(!string.IsNullOrEmpty(this.messageDeactivate)) SendMessage(this.messageDeactivate, SendMessageOptions.DontRequireReceiver);
			}

			this.isActive = this.activated = active;
		}
	}
}
