using UnityEngine;
using UnityEngine.Events;

namespace MIGames.FPS.Props {
	public class SwitchObject : MonoBehaviour {
		public bool defaultState;
		public GameObject objectActive;
		public GameObject objectInactive;
		public Switch toggle;

		protected bool currentState = false;

		void OnEnable() {
			if(this.toggle != null) {
				SetState(this.toggle.activated);
				this.toggle.onSwitchState += OnSwitchState;
			} else {
				SetState(this.defaultState);
			}
		}

		void OnDisable() {
			if(this.toggle != null) {
				this.toggle.onSwitchState -= OnSwitchState;
			}
		}

		void OnInteract() {
			if(this.toggle != null) {
				return;
			}
			SetState(!this.currentState);
		}

		void OnSwitchState(bool state) {
			SetState(state);
		}

		protected void SetState(bool active) {
			if(this.objectActive != null) this.objectActive.SetActive(active);
			if(this.objectInactive != null) this.objectInactive.SetActive(!active);

			this.currentState = active;
		}
	}
}
