using UnityEngine;

namespace MIGames.Items.Inventories {
	public abstract class AbstractInventory : MonoBehaviour, Inventory {
		protected Item GetPickupItem(Item item, int maxAmount) {
			if(item.GetAmount() > maxAmount) {
				Item instance = ((GameObject)Instantiate(item.GetPrefab())).GetComponent<Item>();
				instance.SetAmount(maxAmount);

				item.SetAmount(item.GetAmount() - maxAmount);

				return instance;
			}

			return item;
		}

		public abstract bool CanPickup(Item item);
		public abstract bool TryPickup(Item item);
	}
}
