using UnityEngine;

namespace MIGames.Items.Items {
	public abstract class AbstractItem : MonoBehaviour, Item {
		public string displayName;		
		public Sprite icon;
		
		protected int amount = 1;

		public virtual string GetName() {
			return string.IsNullOrEmpty(this.displayName) ? this.name : this.displayName;
		}

		public virtual Sprite GetIcon() {
			return this.icon;
		}

		public virtual int GetAmount() {
			return this.amount;
		}

		public virtual void SetAmount(int amount) {
			this.amount = amount;
		}

		public virtual GameObject GetPrefab() {
			return this.gameObject;
		}
	}
}
