﻿using UnityEngine;

namespace MIGames.Units.AI {
	public class Actor : MonoBehaviour {
		[Tooltip("Represents the affiliation (or team) of the actor.")]
		public int affiliation;
		[Tooltip("Represents points where other actors will aim when they attack this actor")]
		public Transform[] aimPoints;

		protected ActorManager actorManager;

		private void Start() {
		    this.actorManager = ActorManager.GetInstance();
			this.actorManager.RegisterActor(this);
		}

		private void OnDestroy() {
			this.actorManager.UnregisterActor(this);
		}
	}
}
