﻿using UnityEngine;
using System.Collections.Generic;

namespace MIGames.Units.AI {
	public class ActorManager : MonoBehaviour {
		protected List<Actor> actors = new List<Actor>();
		
		public void RegisterActor(Actor actor) {
			if(!this.actors.Contains(actor)) this.actors.Add(actor);
		}

		public void UnregisterActor(Actor actor) {
			this.actors.Remove(actor);
		}

		public Actor[] GetActors() {
			return this.actors.ToArray();
		}

		protected static ActorManager instance;
		public static ActorManager GetInstance() {
			if(instance != null) {
				return instance;
			}
			instance = GameObject.FindObjectOfType<ActorManager>();
			if(instance != null) {
				return instance;
			}

			instance = (new GameObject("AI Actor Manager")).AddComponent<ActorManager>();
			return instance;
		}
	}
}
