﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Units.Aim {
	public abstract class AbstractUnitAim : MonoBehaviour, UnitAim {
		public UnityAction<GameObject> onTargetChange {get; set;}

		public Vector3 inputScaleRotate;

		protected Vector3 inputRotate;
		protected Vector3 inputDirection = Vector3.forward;

		protected GameObject target;
		protected Vector3 targetPosition;

		public virtual void SetRotateInput(Vector3 rotate) {
			this.inputRotate = Vector3.Scale(rotate, this.inputScaleRotate);
		}

		public virtual void SetDirection(Vector3 direction) {
			this.inputDirection = direction;
		}

		public virtual void SetPoint(Vector3 point) {
			this.inputDirection = (point - GetAimOrigin()).normalized;
		}

		public virtual Vector3 GetAimOrigin() {
			return this.transform.position;
		}

		public virtual Vector3 GetAimDirection() {
			return this.inputDirection;
		}

		public virtual GameObject GetAimTarget() {
			return this.target;
		}

		public virtual Vector3 GetAimTargetPosition() {
			return this.targetPosition;
		}

		protected virtual void SetTarget(GameObject target, Vector3 targetPosition) {
			bool targetChanged = target != this.target;
			this.target = target;
			this.targetPosition = targetPosition;
			if(targetChanged && this.onTargetChange != null) this.onTargetChange.Invoke(target);
		}
	}
}
