﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using MIGames.Utilities;

namespace MIGames.Units {
	public class UnitRagdoll : MonoBehaviour {
		public bool activated;
		public Animator animator;
		public Transform parent;

		[Layer]
		public int defaultLayer = 1;
		[Layer]
		public int ragdollLayer = 1;

		protected Rigidbody[] bodies;
		protected bool isActivated;

		void Start() {
			if(this.animator == null) this.animator = GetComponent<Animator>();
			if(this.parent == null) this.parent = this.transform;

			this.bodies = this.parent.GetComponentsInChildren<Rigidbody>();

			SetRagdollActive(this.activated);
		}

		void Update() {
			if(this.activated != this.isActivated) {
				SetRagdollActive(this.activated);
			}
		}

		void OnDeath() {
			SetRagdollActive(true);
		}

		public void SetRagdollActive(bool activated) {
			foreach(Rigidbody body in this.bodies) {
				body.isKinematic = !activated;
				body.gameObject.layer = activated ? this.ragdollLayer : this.defaultLayer;
			}

			this.animator.enabled = !activated;
			this.isActivated = this.activated = activated;
		}
	}
}
