﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace MIGames.Units.Movement {
	public abstract class AbstractUnitMovement : MonoBehaviour, UnitMovement {
		public Vector3 inputScaleMove;
		public Vector3 inputScaleRotate;

		protected Vector3 inputMove;
		protected Vector3 inputRotate;

		public virtual void SetMoveInput(Vector3 move) {
			this.inputMove = Vector3.Scale(move, this.inputScaleMove);
		}

		public virtual void SetRotateInput(Vector3 rotate) {
			this.inputRotate = Vector3.Scale(rotate, this.inputScaleRotate);
		}

		public abstract Vector3 GetVelocity();
		public abstract Vector3 GetAngularVelocity();
	}
}
