using UnityEngine;
	
namespace MIGames.Weapons.Actions {
	public class StandardWeaponSpray : MonoBehaviour, WeaponSpray {
		[Header("General")]
		[Tooltip("Focus distance for spray calculation. Raising this value lowers the overall spray range.")]
		public float sprayFocus = 100f;

    	[Header("Spread")]
    	[Tooltip("Enable or disable basic Spread.")]
		public bool spreadEnabled = false;
    	[Tooltip("Basic, weapon spread range")]
		public Vector2 spread = new Vector2(1f, 1f);

    	[Header("Movement Inaccuracy")]
    	[Tooltip("Enable or disable movement inaccuracy.")]
		public bool movementInaccuracyEnabled = false;
    	[Tooltip("Inaccuracy resulting from movement. Get's multiplied by current speed. Requires a rigidbody in parent.")]
		public Vector2 movementInaccuracy = new Vector2(1f, 1f);
		
    	[Header("Recoil")]
    	[Tooltip("Enable or disable recoil.")]
		public bool recoilEnabled = false;
    	[Tooltip("Should recoil get applied to aim transform?")]
		public bool aimRecoilEnabled = false;
    	[Tooltip("Recoil force multiplier.")]
		public Vector2 recoilPower = new Vector2(10f, 10f);
    	[Tooltip("Recoil time multiplier.")]
		public Vector2 recoilSpeed = new Vector2(1f, 1f);
    	[Tooltip("Rate of recoil decay.")]
		public float recoilDecay = 10f;
    	[Tooltip("Time before recoil decay starts.")]
		public float recoilDecayTimeout = 0.1f;
    	[Tooltip("Recoil curve on X-Axis. ")]
		public AnimationCurve recoilX;
    	[Tooltip("Recoil curve on Y-Axis.")]
		public AnimationCurve recoilY;
		
		/*
		// sketch 1
		// the simple recoil, that controls the camera/
		protected Vector2 currentRecoil;
		*/

		/*
		// sketch 2
		protected float currentRecoil = 0f;
		protected float currentRecoilAccumulated = 0f;
		protected Vector2 currentRecoilOffset = new Vector2();
		*/

		// sketch 3
		protected float currentRecoil;
		protected float currentRecoilDecay;
		protected Vector2 currentRecoilOffset;
		protected Vector2 currentRecoilOffsetRemaining;

		protected Transform currentParent;
		protected Transform aim;
		protected Quaternion aimRotation;

		protected Rigidbody body;
		protected CharacterController character;

		void Start() {
		}
		
		void Update() {
			/*
			// sketch 1
			if(this.aimRecoilEnabled && this.aim != null) {
				Vector2 recoil = new Vector2(
					this.currentRecoil.x * this.recoilPower.x,
					this.currentRecoil.y * this.recoilPower.y
				);
				this.aim.localRotation = Quaternion.LookRotation(new Vector3(recoil.x, recoil.y, this.sprayFocus)) * this.aimRotation;
			}

			this.currentRecoil = Vector2.MoveTowards(this.currentRecoil, new Vector2(), Time.deltaTime * this.recoilDecay);
			*/

			/*
			// sketch 2
			if(this.aimRecoilEnabled && this.aim != null) {
				Vector2 recoil = Vector2.Lerp(this.currentRecoilOffset, new Vector2(), 1f - this.currentRecoil);

				this.aim.localRotation = Quaternion.LookRotation(new Vector3(recoil.x, recoil.y, this.sprayFocus)) * this.aimRotation;
			}

			this.currentRecoil = Mathf.MoveTowards(this.currentRecoil, 0f, Time.deltaTime * this.recoilDecay);
			if(this.currentRecoil <= 0f) {
				this.currentRecoilAccumulated = 0f;
				this.currentRecoilOffset = new Vector2();
			}
			*/

			// sketch 3
			if(this.currentRecoil > 0f) {
				// aim recoil
				if(this.aimRecoilEnabled) {
					Vector2 recoil = this.currentRecoilOffsetRemaining;

					this.aim.localRotation = Quaternion.LookRotation(new Vector3(recoil.x, recoil.y, this.sprayFocus)) * this.aimRotation;
				}
		
				// recoil decay
				if(this.currentRecoilDecay >= this.recoilDecayTimeout) {
					this.currentRecoilOffsetRemaining = Vector2.MoveTowards(
						this.currentRecoilOffsetRemaining, 
						new Vector2(), 
						Time.deltaTime * this.recoilDecay
					);
					//this.currentRecoil = ;

					//this.currentRecoil = Mathf.MoveTowards(this.currentRecoil, 0f, Time.deltaTime * this.recoilDecay);
					if(this.currentRecoil <= 0f) {
						this.currentRecoilOffset = this.currentRecoilOffsetRemaining = new Vector2();
						this.currentRecoil = 0f;
						this.currentRecoilDecay = 0f;
						this.aim.localRotation = this.aimRotation;
					}
				}

				if(this.currentRecoil > 0f) this.currentRecoilDecay += Time.deltaTime;
			}

			if(this.currentParent != this.transform.parent) {
				this.body = GetComponentInParent<Rigidbody>();
				this.character = GetComponentInParent<CharacterController>();
				this.currentParent = this.transform.parent;
			}
		}

		public void SetAim(Transform aim) {
			if(aim == null) aim = this.transform;
			this.aim = aim;
			this.aimRotation = aim.localRotation;
		}

		public Ray Modify(Ray ray, WeaponTriggerData trigger) {
			Vector2 spray = new Vector2();
			
			if(this.spreadEnabled) {
				spray += new Vector2(
					Random.Range(-1f, 1f) * this.spread.x,
					Random.Range(-1f, 1f) * this.spread.y
				);				
			}

			if(this.movementInaccuracyEnabled) {
				float speed = 0f;
				if(this.character != null) speed = this.character.velocity.magnitude;
				else if(this.body != null) speed = this.body.velocity.magnitude;

				spray += new Vector2(
					Random.Range(-1f, 1f) * this.movementInaccuracy.x * speed,
					Random.Range(-1f, 1f) * this.movementInaccuracy.y * speed
				);	
			}

			if(this.recoilEnabled) {	
				/*
				//sketch 1
				spray += new Vector2(
					this.currentRecoil.x * this.recoilPower.x,
					this.currentRecoil.y * this.recoilPower.y
				);
				*/

				/*
				// sketch 2
				spray += Vector2.Lerp(this.currentRecoilOffset, new Vector2(), 1f - this.currentRecoil);
				*/

				spray += new Vector2(
					this.currentRecoilOffsetRemaining.x,
					this.currentRecoilOffsetRemaining.y
				);
			}

			Transform aim = this.aim != null ? this.aim : this.transform;
			Vector3 direction = aim.InverseTransformDirection(ray.direction);
			direction = Quaternion.LookRotation(new Vector3(spray.x, spray.y, this.sprayFocus)) * direction;
			ray.direction = aim.TransformDirection(direction);
			
			/*
			// sketch 1
			// calculate recoil for the NEXT shot
			float eval = (float)trigger.volleyIndex;
			this.currentRecoil = new Vector2(
				this.recoilX.Evaluate(eval * this.recoilSpeed.x),
				this.recoilY.Evaluate(eval * this.recoilSpeed.y)
			);
			*/

			/*
			// sketch 2
			// calculate recoil for the NEXT shot
			float eval = this.currentRecoilAccumulated;
			this.currentRecoil = 1f;
			this.currentRecoilAccumulated = this.currentRecoilAccumulated + 1f;
			this.currentRecoilOffset = new Vector2(
				this.recoilX.Evaluate(eval * this.recoilSpeed.x) * this.recoilPower.x,
				this.recoilY.Evaluate(eval * this.recoilSpeed.y) * this.recoilPower.y
			);
			*/

			// sketch 3
			// calculate recoil for the NEXT shot
			if(this.recoilEnabled) {	
				if(this.currentRecoil > 0f) {
					this.currentRecoil = this.currentRecoilOffsetRemaining.magnitude / this.currentRecoilOffset.magnitude * this.currentRecoil;
				}
				float eval = this.currentRecoil;
				this.currentRecoil += 1f;
				this.currentRecoilDecay = 0f;
				this.currentRecoilOffsetRemaining = this.currentRecoilOffset = new Vector2(
					this.recoilX.Evaluate(eval * this.recoilSpeed.x) * this.recoilPower.x,
					this.recoilY.Evaluate(eval * this.recoilSpeed.y) * this.recoilPower.y
				);
			}

			return ray;
		}
	}
}
