﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using MIGames.Weapons.Handlers;

namespace MIGames.Weapons.Animations {
	public class WeaponHandlerIK : MonoBehaviour {
		public bool activated = true;

		public Animator animator;
		public GameObject weapon;
		public WeaponHandler handler;
		
		protected WeaponHandlerIKTargets ikTargets;

		protected Vector3 leftHandPosition;
		protected Vector3 rightHandPosition;

		void Start() {
			if(this.animator == null) {
				this.animator = GetComponent<Animator>();
			}

			if(this.handler == null && this.weapon == null) {
				this.handler = GetComponentInParent<WeaponHandler>();
			}
			if(this.handler != null) {
				this.handler.onWeaponSwitch += OnWeaponSwitch;
				OnWeaponSwitch(this.handler.GetActiveWeapon());
			} else {
				OnWeaponSwitch(this.weapon);
			}
		}

		void OnWeaponSwitch(GameObject weapon) {
			this.ikTargets = weapon != null ? weapon.GetComponent<WeaponHandlerIKTargets>() : null;
		}

		/*void OnDeath() {
			this.activated = false;
		}

		void OnRevive() {
			this.activated = true;
		}*/

		void OnAnimatorIK() {
			if(!this.activated || this.ikTargets == null) {
				return;
			}

			if(this.ikTargets.handLeft != null) {
				this.animator.SetIKPosition(AvatarIKGoal.LeftHand, this.leftHandPosition);
				this.animator.SetIKPositionWeight(AvatarIKGoal.LeftHand, 1f);
			}

			if(this.ikTargets.handRight != null) {
				this.animator.SetIKPosition(AvatarIKGoal.RightHand, this.rightHandPosition);
				this.animator.SetIKPositionWeight(AvatarIKGoal.RightHand, 1f);
			}
		}

		void Update() {
			if(!this.activated || this.ikTargets == null) {
				return;
			}

			if(this.ikTargets.handLeft != null) this.leftHandPosition = this.ikTargets.handLeft.position;
			if(this.ikTargets.handRight != null) this.rightHandPosition = this.ikTargets.handRight.position;
		}
	}
}
