using UnityEngine;
using UnityEngine.AI;
using System.Collections.Generic;

namespace MIGames.Weapons {
	public class Bulletholes : MonoBehaviour {
		public enum DynamicObjectBehaviour { None, Ignore, Sticky }

		/*public bool physicsEnabled;*/
		public ParticleSystem[] particles;
		public DynamicObjectBehaviour dynamicObjectBehaviour = DynamicObjectBehaviour.None;

		/*protected bool dynamicParticlesEnabled {get{return this.physicsEnabled;}}*/

		protected WeaponController weapon;
    
		/*protected ParticleSystem.Particle[] particleInstances;
		protected Transform[] parents;
		protected Vector3 parentPositions;
		protected Vector3 parentRotations;*/

		void Start() {
			this.weapon = GetComponent<WeaponController>();
			if(this.weapon != null) {
				this.weapon.RegisterHitAction(TriggerHit);
			}

			/*if(this.dynamicParticlesEnabled) {
				this.particleInstances = new ParticleSystem.Particle[this.particles.main.maxParticles];
				this.parents = new Transform[this.particleInstances.length];
				this.parentPositions = new Vector3[this.particleInstances.length];
				this.parentRotations = new Vector3[this.particleInstances.length];
			}*/
		}

		void TriggerHit() {
			WeaponHitData data = this.weapon.GetCurrentHitData();
			Spawn(data.point, data.normal, data.collider);
		}

		protected void Spawn(Vector3 point, Vector3 normal, Collider collider) {
			if(this.dynamicObjectBehaviour != DynamicObjectBehaviour.None) {
				bool isDynamic = 
					collider.GetComponentInParent<Rigidbody>() != null 
					|| collider.GetComponentInParent<CharacterController>() != null 
					|| collider.GetComponentInParent<NavMeshAgent>() != null
				;
				if(isDynamic) {
					switch(this.dynamicObjectBehaviour) {
						case DynamicObjectBehaviour.Ignore:
							return;
						case DynamicObjectBehaviour.Sticky:
							// TODO: implement sticky bulletholes
							Debug.LogWarning("Sticky particles aren't implemented yet.");							
							break;
					}
				}
			}

			ParticleSystem.EmitParams emitParams = new ParticleSystem.EmitParams();
			emitParams.position = point;

			Vector3 direction = new Vector3(normal.x, normal.y, -normal.z);
			emitParams.rotation3D = Quaternion.LookRotation(direction).eulerAngles;

			foreach(ParticleSystem system in this.particles) {
				system.gameObject.layer = 1;
				system.Emit(emitParams, 1);
			}

			/*if(this.dynamicParticlesEnabled) {
				int numParticlesAlive = this.particles.GetParticles(this.particleInstances);

				if(this.physicsEnabled && collider != null) {
					Rigidbody body = collider.GetComponentInParent<Rigidbody>();
					CharacterController character = body == null ? collider.GetComponentInParent<CharacterController>() : null;

					if(body != null || character != null) {
						this.parents[]
					}
				}
			}*/
		}
	}
}
