using UnityEngine;

namespace MIGames.Weapons.FX {
	public class WeaponVFX : WeaponFX {
		public Transform muzzle;

		public WeaponVFXPrefab triggerVFX;
		public WeaponVFXPrefab hitVFX;

		protected override void Load() {
			this.triggerVFX.Load(this.muzzle != null ? this.muzzle.gameObject : this.gameObject);
			this.hitVFX.Load(this.gameObject);
		}

		protected override void Unload() {
			this.triggerVFX.Unload();
			this.hitVFX.Unload();
		}

		protected override void Trigger(WeaponTriggerData data) {
			this.triggerVFX.Trigger();
		}

		protected override void Hit(WeaponHitData data) {
			this.hitVFX.Trigger(data.collider.transform, data.point, Quaternion.LookRotation(data.normal));
		}
	}
}
