using UnityEngine;

namespace MIGames.Weapons.FX {
	public class WeaponVFXInstance : MonoBehaviour {
		public Transform parent;
		public float duration = 2f;

		void OnEnable() {
			Spawn();
		}

		void OnDespawn() {
			Despawn();
		}

		void Spawn() {
			CancelInvoke("Despawn");			
			Invoke("Despawn", this.duration);
		}

		void Despawn() {
			this.gameObject.SetActive(false);
			this.transform.parent = this.parent;
		}
	}
}
