using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Weapons.Handlers {
	public class WeaponHandler : MonoBehaviour {
		//public GameObject defaultWeapon;

		public Transform aim;	
		public float equipTime = 0.5f;
		public float unequipTime = 0.25f;

		public UnityAction<GameObject> onWeaponSwitch;	

		protected GameObject equipped;
		protected WeaponController equippedController;

		protected GameObject switchTo;
		
		void Start() {
			// TODO: get rid of FPSMicrogame dependency
			PlayerWeaponsManager legacyHandler = GetComponent<PlayerWeaponsManager>();
			legacyHandler.onSwitchedToWeapon += OnSwitchedWeapon;
			
			MonoBehaviour equippedLegacyWeapon = legacyHandler.GetActiveWeapon();
			if(equippedLegacyWeapon != null) {
				SwitchTo(equippedLegacyWeapon.gameObject);
			}	
		}

		void OnSwitchedWeapon(MonoBehaviour legacyWeapon) {
			// TODO: get rid of FPSMicrogame dependency
			Equip(legacyWeapon.gameObject);
		}

		void OnDeath() {
			GetComponent<PlayerWeaponsManager>().SwitchToWeaponIndex(-1, true);
		}

		void PerformSwitch() {
			Equip(this.switchTo);
			
			if(this.equippedController != null) {
				this.equippedController.SetReady(false);
				this.equippedController.SetReady(true, this.equipTime);
			}
		}

		public void SwitchTo(GameObject weapon) {
			if(this.equipped != null) {
				if(this.equippedController != null) {
					this.equippedController.SetReady(false);
				}

				this.switchTo = weapon;
				//if already switching to another weapon, just inherit unequip timer
				if(!IsInvoking("PerformSwitch")) Invoke("PerformSwitch", this.unequipTime);	
			} else {
				this.switchTo = weapon;
				CancelInvoke("PerformSwitch");
				PerformSwitch();
			}
		}

		public void Equip(GameObject weapon) {
			if(this.equippedController != null) {
				this.equippedController.SetAim(null);
				this.equippedController.SetHandler(null);
				this.equippedController.SetReady(true);
				// TODO: actual unequip logic here
			}
			
			WeaponController controller = weapon != null ? weapon.GetComponent<WeaponController>() : null;
			if(controller != null) {
				controller.SetAim(this.aim);
				controller.SetHandler(this);
				controller.SetReady(true);
				// TODO: actual equip logic here
			}

			this.equipped = weapon;
			this.equippedController = controller;

			this.onWeaponSwitch.Invoke(weapon);
		}

		public GameObject GetActiveWeapon() {
			return this.equipped;
		}
	}
}
