using UnityEngine;
using UnityEngine.UI;

namespace MIGames.Weapons.HitReceivers {
	public class HitAimpunch : MonoBehaviour, WeaponHitReceiver {
		public Transform target;
		public float decay = 1f;
		public float powerFactor = 1f;
		public float powerMin = 0f;
		public float powerMax = 0f;
		
		protected float accumulated;
	
		public void RegisterHit(WeaponHitData data) {
			float apply = data.vulnerability * this.powerFactor;
			if(apply < this.powerMin) {
				return;
			}
			if(this.powerMax > 0f && apply > this.powerMax) {
				apply = this.powerMax;
			}
			
			Apply(apply);
		}
		
		public void Apply(float power) {
			this.accumulated += power;
			
			this.target.Rotate(new Vector3(-power, 0, 0), Space.Self);
		}
		
		void Update() {
			if(this.accumulated <= 0f) {
				return;
			}
			float decay = Mathf.Min(this.decay * Time.deltaTime, this.accumulated);
			
			Apply(-decay);
		}
	}
}
