using UnityEngine;

namespace MIGames.Weapons.Triggers {
	public abstract class AbstractIntervalTrigger : AbstractTrigger {
		public float rpm = 667f;

		public float rps {get{return this.rpm / 60f;}}
		public float cooldown {get{return 1f / this.rps;}}
		public float cooldownRemaining {get{return Mathf.Max(0f, this.cooldown - (GetTime() - this.lastShot));}}

		protected float lastShot = 0f;

		public override bool CanTrigger() {
			return true;
		}

		protected override void TriggerShot(WeaponTriggerData data) {
			this.lastShot = data.time;
			base.TriggerShot(data);
		}

		protected float GetTime() {
			return Time.realtimeSinceStartup;
		}

		protected virtual bool IsReady() {
			return GetTime() - this.lastShot >= this.cooldown;
		}
	}
}
