using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Weapons.Triggers {
	public abstract class AbstractTrigger : MonoBehaviour, WeaponTrigger {
		protected UnityAction onTrigger;
		protected UnityAction onTriggerStart;
		protected UnityAction onTriggerEnd;
		protected float weight = 1f;

		protected WeaponTriggerData currentData;
		
		// --- (un)register event handlers

		public virtual void RegisterTriggerAction(UnityAction handler) {
			this.onTrigger += handler;
		}

		public virtual void UnregisterTriggerAction(UnityAction handler) {
			this.onTrigger -= handler;
		}

		public virtual void RegisterTriggerStartAction(UnityAction handler) {
			this.onTriggerStart += handler;
		}

		public virtual void UnregisterTriggerStartAction(UnityAction handler) {
			this.onTriggerStart -= handler;
		}

		public virtual void RegisterTriggerEndAction(UnityAction handler) {
			this.onTriggerEnd += handler;
		}

		public virtual void UnregisterTriggerEndAction(UnityAction handler) {
			this.onTriggerEnd -= handler;
		}

		// --- set/get options

		public virtual void SetWeight(float weight) {
			this.weight = weight;
		}

		public virtual WeaponTriggerData GetCurrentTriggerData() {
			return this.currentData;
		}

		// --- trigger events

		protected virtual void TriggerShot(WeaponTriggerData data) {
			this.currentData = data;
			if(this.onTrigger != null) this.onTrigger.Invoke();
		}

		protected virtual void TriggerShotStart() {
			if(this.onTriggerStart != null) this.onTriggerStart.Invoke();
		}

		protected virtual void TriggerShotEnd() {
			if(this.onTriggerEnd != null) this.onTriggerEnd.Invoke();
		}

		// --- abstracts

		public abstract bool CanTrigger();
		public abstract void Break();
		public abstract void TriggerStart();
		public abstract void TriggerEnd();
	}
}
