using UnityEngine;

namespace MIGames.Weapons.Triggers {
	public class AutomaticTrigger : AbstractIntervalTrigger {
		public float accelerationDuration = 0f;

		protected bool triggered;
		protected float started = 0f;
		protected int volley = 0;

		void Update() {
			if(!this.triggered) {
				return;
			}
			TriggerUpdate();
		}

		public override void Break() {
			if(this.triggered) {
				TriggerShotEnd();
			}

			this.volley = 0;
			this.started = 0f;
			this.triggered = false;
		}

		public override void TriggerStart() {
			this.triggered = true;
			this.started = GetTime();
			this.volley = 0;
			//this.lastShot = this.started;

			//float timeSinceLastShot = this.started - this.lastShot;

			if(IsReady()) {
				TriggerShotStart();
				TriggerShot(new WeaponTriggerData(GetTime(), 1f, 0, 0f, this));
				this.volley++;
			}

			// if trigger was blocked by other than cooldown
			// else if(this.cooldownRemaining <= 0f) {
			//	this.lastShot = this.started - this.cooldown;
			//}
		}

		public override void TriggerEnd() {
			if(!this.triggered) {
				return;
			}

			TriggerShotEnd();
			//TriggerUpdate();

			this.triggered = false;
		}

		protected void TriggerUpdate() {
			// trigger all shots that should have happened since last update
			float lastShot = this.lastShot;
			float delta = GetTime() - lastShot;
			int shots = Mathf.FloorToInt(delta * this.rps);
			for(int s = 0; s < shots; s++) {
				float time = lastShot + (float)(s + 1) / this.rps;
				TriggerShot(new WeaponTriggerData(time, 1f, this.volley, time - this.started, this));
				this.volley++;
			}

			// correct last shot time
			//this.lastShot = lastShot + (float)shots * this.cooldown;
		}
	}
}
