using UnityEngine;
using UnityEngine.UI;

using MIGames.Weapons.Handlers;

namespace MIGames.Weapons.UI {
	public class WeaponUI : MonoBehaviour {
		public WeaponHandler handler;
		public GameObject weapon;

		public Sprite defaultIcon;
		public Color defaultColor;
		public Color highlightColor;

		public Transform wrapper;
		public Text displayName;
		public Image icon;

		protected bool highlight;

		void Start() {
			if(this.handler != null) {
				Setup(this.handler.GetActiveWeapon());
				this.handler.onWeaponSwitch += OnWeaponSwitch;
			} else {
				Setup(this.weapon);
			}
		}

		void OnWeaponSwitch(GameObject weapon) {
			Setup(weapon);
		}

		public virtual void Setup(GameObject weapon) {
			this.weapon = weapon;
			Setup();
		}

		public virtual void Setup() {
			if(this.wrapper != null) this.wrapper.gameObject.SetActive(this.weapon != null);
			if(this.weapon == null) {
				return;
			}

			WeaponProfile profile = this.weapon.GetComponent<WeaponProfile>();
			if(this.displayName != null) this.displayName.text = profile != null ? profile.displayName : "";
			if(this.icon != null) this.icon.sprite = profile != null && profile.icon != null ? profile.icon : this.defaultIcon;

			SetHighlight(false);
		}

		public virtual void SetHighlight(bool highlight) {
			this.highlight = highlight;

			SetColor(highlight ? this.highlightColor : this.defaultColor);
		}

		public virtual void SetColor(Color color) {
			if(this.displayName != null) this.displayName.color = color;
			if(this.icon != null) this.icon.color = color;
		}
	}
}
