using UnityEngine;
using UnityEngine.Events;
	
namespace MIGames.Weapons {
	public struct WeaponHitData {
		public Vector3 point;
		public Vector3 force;
		public Vector3 normal;
		public Collider collider;
		public GameObject weapon;
		public GameObject source;
		public float distance;
		public float vulnerability;
		
		public WeaponHitData(Vector3 point, Vector3 force, Vector3 normal, Collider collider, float distance, GameObject weapon, GameObject source) {
			this.point = point;
			this.force = force;
			this.normal = normal;
			this.collider = collider;
			this.distance = distance;
			this.weapon = weapon;
			this.source = source;

			this.vulnerability = 1f;
		}
	}
	
	public interface WeaponAction {
		bool CanPerform(WeaponTriggerData trigger);
		bool TryPerform(WeaponTriggerData trigger);
		bool IsPerforming();

		void RegisterPerformAction(UnityAction action);
		void UnregisterPerformAction(UnityAction action);

		void RegisterPerformStartAction(UnityAction action);
		void UnregisterPerformStartAction(UnityAction action);
		void RegisterPerformEndAction(UnityAction action);
		void UnregisterPerformEndAction(UnityAction action);

		void RegisterHitAction(UnityAction action);
		void UnregisterHitAction(UnityAction action);

		WeaponHitData GetCurrentHitData();
		void SetAim(Transform aim);
		Transform GetAim();
	}
}
