using UnityEngine;
using UnityEngine.Events;
	
namespace MIGames.Weapons {
	public class WeaponAnimator : MonoBehaviour {
		public Animator animator;

		[Header("Trigger")]
		[Tooltip("Enable trigger events?")]
		public bool triggerEnabled = false;
		[Tooltip("Name of trigger event trigger.")]
		public string triggerName;
		[Tooltip("Name of trigger start trigger.")]
		public string triggerStartName;
		[Tooltip("Name of trigger end trigger.")]
		public string triggerEndName;
		[Tooltip("Name of trigger active param.")]
		public string triggerActiveName;

		[Header("Action")]
		[Tooltip("Enable action events?")]
		public bool actionEnabled = true;
		[Tooltip("Name of action trigger.")]
		public string actionName = "Trigger";
		[Tooltip("Name of action start trigger.")]
		public string actionStartName;
		[Tooltip("Name of action end trigger.")]
		public string actionEndName;
		[Tooltip("Name of action active param.")]
		public string actionActiveName;

		[Header("Reload")]
		[Tooltip("Enable reload events?")]
		public bool reloadEnabled = true;
		[Tooltip("Name of reload start trigger.")]
		public string reloadStartName;
		[Tooltip("Name of reload apply trigger.")]
		public string reloadApplyName;
		[Tooltip("Name of reload end trigger.")]
		public string reloadEndName;
		[Tooltip("Name of reload active param.")]
		public string reloadActiveName = "Reloading";

		protected WeaponTrigger trigger;
		protected WeaponAction action;
		protected WeaponCharge charge;

		void Start() {
			if(this.triggerEnabled) {
				this.trigger = GetComponent<WeaponTrigger>();
				if(this.trigger != null) {
					this.trigger.RegisterTriggerAction(Trigger);
					this.trigger.RegisterTriggerStartAction(TriggerStart);
					this.trigger.RegisterTriggerEndAction(TriggerEnd);
				}
			}

			if(this.actionEnabled) {
				this.action = GetComponent<WeaponAction>();
				if(this.action != null) {
					this.action.RegisterPerformAction(Action);
					this.action.RegisterPerformStartAction(ActionStart);
					this.action.RegisterPerformEndAction(ActionEnd);
				}
			}

			if(this.reloadEnabled) {
				this.charge = GetComponent<WeaponCharge>();
				if(this.charge != null) {
					this.charge.RegisterReloadStartAction(ReloadStart);
					this.charge.RegisterReloadEndAction(ReloadEnd);
					this.charge.RegisterReloadApplyAction(ReloadApply);
				}
			}

			//TODO: equip/unequip
		}

		// --- event receivers

		void Trigger() {
			SetTrigger(this.triggerName);
		}

		void TriggerStart() {
			SetTrigger(this.triggerStartName);
			SetBool(this.triggerActiveName, true);
		}

		void TriggerEnd() {
			SetTrigger(this.triggerEndName);
			SetBool(this.triggerActiveName, false);
		}

		void Action() {
			SetTrigger(this.actionName);
		}

		void ActionStart() {
			SetTrigger(this.actionStartName);
			SetBool(this.actionActiveName, true);
		}

		void ActionEnd() {
			SetTrigger(this.actionEndName);
			SetBool(this.actionActiveName, false);
		}

		void ReloadStart() {
			SetTrigger(this.reloadStartName);
			SetBool(this.reloadActiveName, true);
		}

		void ReloadApply() {
			SetTrigger(this.reloadApplyName);
		}

		void ReloadEnd() {
			SetTrigger(this.reloadEndName);
			SetBool(this.reloadActiveName, false);
		}

		// --- helpers

		protected void SetTrigger(string param) {
			if(this.animator == null || string.IsNullOrEmpty(param)) {
				return;
			}
			this.animator.SetTrigger(param);
		}

		protected void SetBool(string param, bool val) {
			if(this.animator == null || string.IsNullOrEmpty(param)) {
				return;
			}
			this.animator.SetBool(param, val);
		}

		protected void SetFloat(string param, float val) {
			if(this.animator == null || string.IsNullOrEmpty(param)) {
				return;
			}
			this.animator.SetFloat(param, val);
		}

		protected void SetInteger(string param, int val) {
			if(this.animator == null || string.IsNullOrEmpty(param)) {
				return;
			}
			this.animator.SetInteger(param, val);
		}
	}
}
