using UnityEngine;
using UnityEngine.Events;
	
namespace MIGames.Weapons {
	public interface WeaponCharge {
		bool CanSupply(WeaponTriggerData trigger);
		bool TrySupply(WeaponTriggerData trigger, out float charge);

		bool CanReload();
		bool TryReload();
		bool IsReloading();
		void BreakReload();

		void SetCharge(float charge);
		float GetCharge();

		void RegisterChargeUpdateAction(UnityAction action);
		void UnregisterChargeUpdateAction(UnityAction action);

		void RegisterReloadStartAction(UnityAction action);
		void UnregisterReloadStartAction(UnityAction action);
		void RegisterReloadEndAction(UnityAction action);
		void UnregisterReloadEndAction(UnityAction action);
		void RegisterReloadApplyAction(UnityAction action);
		void UnregisterReloadApplyAction(UnityAction action);
	}
}
