using UnityEngine;

namespace MIGames.Weapons {
	public abstract class WeaponFX : MonoBehaviour {
		protected WeaponController weapon;

		protected bool triggerLocked = false;
		protected bool hitLocked = false;
	
		void Start() {
			this.weapon = GetComponent<WeaponController>();
			this.weapon.RegisterTriggerAction(TriggerShot);
			this.weapon.RegisterHitAction(HitShot);

			Load();
		}

		void OnDestroy() {
			Unload();
		}

		void Update() {
			this.triggerLocked = false;
			this.hitLocked = false;
		}

		void TriggerShot() {
			if(this.triggerLocked) {
				return;
			}

			Trigger(this.weapon.GetCurrentTriggerData());

			this.triggerLocked = true;
		}

		void HitShot() {
			if(this.hitLocked) {
				return;
			}

			Hit(this.weapon.GetCurrentHitData());

			this.hitLocked = true;
		}

		protected abstract void Load();
		protected abstract void Unload();
		protected abstract void Trigger(WeaponTriggerData data);
		protected abstract void Hit(WeaponHitData data);
	}
}
