using UnityEngine;

namespace MIGames.FPS.Units {
	public class Turret : MonoBehaviour {
		public Transform aimY;
		public Transform aimX;
		public Transform muzzle;

		protected EnemyController enemyController;

		protected bool activated = false;

		void Start() {
        	this.enemyController = GetComponent<EnemyController>();
		    this.enemyController.onDetectedTarget += OnDetectedTarget;
		    this.enemyController.onLostTarget += OnLostTarget;

			Setup();		
		}

		void Update() {
            if(this.enemyController.isSeeingTarget) {
				UpdateMuzzle();
			}
		}

		protected void Setup() {
			if(this.muzzle != null) this.enemyController.weapon.transform.SetParent(this.muzzle);
		}

		protected void UpdateMuzzle() {
			Vector3 target = this.enemyController.knownDetectedTarget.transform.position;
			
			this.aimY.LookAt(new Vector3(target.x, this.aimY.position.y, target.z), new Vector3(0f, 1f, 0f));
			this.aimX.LookAt(target, new Vector3(0f, 1f, 0f));

			this.enemyController.TryAtack((target - this.enemyController.weapon.transform.position).normalized);
		}

		protected void OnDetectedTarget() {
			this.activated = true;
		}

		protected void OnLostTarget() {
			this.activated = false;
		}
	}
}
