using UnityEngine;
using UnityEngine.UI;

namespace MIGames.UI.Demo {
	public class DemoUI : MonoBehaviour {
		[System.Serializable]
		public class DemoUIStage {
			public string title;
			public Sprite icon;
			public string text;
			
			public DemoUIStage() {}
			
			public DemoUIStage(string title) {
				this.title = title;
			}
		}
		
		public DemoUIStage[] stages = new DemoUIStage[] {new DemoUIStage("Welcome!"), new DemoUIStage("See ya!")};
		public string nextKey = "f12";
		public float transitionSpeed = 2f;
		public bool loop = false;
		
		public TMPro.TextMeshProUGUI displayTitle;
		public TMPro.TextMeshProUGUI displayText;
		public Image displayIcon;
		public Image displayBackground;
		
		protected Color titleColor;
		protected Color textColor;
		protected Color iconColor;
		protected Color backgroundColor;
		
		protected float currentValue;
		protected float targetValue;
		
		protected int currentStage = 0;
		protected int nextStage = 0;
		
		void OnEnable() {
			if(this.displayTitle != null) this.titleColor = this.displayTitle.color;
			if(this.displayText != null) this.textColor = this.displayText.color;
			if(this.displayIcon != null) this.iconColor = this.displayIcon.color;
			if(this.displayBackground != null) this.backgroundColor = this.displayBackground.color;
			
			this.currentValue = 0f;
			this.targetValue = 1f;
			
			this.currentStage = -1;
			this.nextStage = 0;
			
			SetProgress(this.currentValue);
		}
		
		void OnDisable() {
			if(this.displayTitle != null) this.displayTitle.color = this.titleColor;
			if(this.displayText != null) this.displayText.color = this.textColor;
			if(this.displayIcon != null) this.displayIcon.color = this.iconColor;
			if(this.displayBackground != null) this.displayBackground.color = this.backgroundColor;
			this.currentValue = this.targetValue = 0f;
		}
		
		void Update() {
			if(this.currentStage != this.nextStage && this.currentValue == 0f) {
				if(this.displayTitle != null) this.displayTitle.text = this.stages[this.nextStage].title;
				if(this.displayText != null) this.displayText.text = this.stages[this.nextStage].text;
				if(this.displayIcon != null) this.displayIcon.sprite = this.stages[this.nextStage].icon;
				this.currentStage = this.nextStage;
				this.targetValue = 1f;
			}
			
			if(this.currentValue != this.targetValue) {
				this.currentValue = Mathf.MoveTowards(this.currentValue, this.targetValue, Time.deltaTime * this.transitionSpeed);
				SetProgress(this.currentValue);
			}
			
			if(Input.GetKeyDown(this.nextKey)) {
				int next = this.nextStage + 1;
				if(next >= this.stages.Length) {
					if(!this.loop) {
						return;
					}
					next = 0;
				}
				SetStage(next);
			}
		}
		
		protected void SetProgress(float o) {
			if(this.displayTitle != null) {
				Color titleColor = this.titleColor;
				titleColor.a = this.titleColor.a * o;
				this.displayTitle.color = titleColor;
			}
			
			if(this.displayText != null) {
				Color textColor = this.textColor;
				textColor.a = this.textColor.a * o;
				this.displayText.color = textColor;
			}
			
			if(this.displayIcon != null) {
				Color iconColor = this.iconColor;
				iconColor.a = this.iconColor.a * o;
				this.displayIcon.color = iconColor;
			}
			
			if(this.displayBackground != null) {
				Color backgroundColor = this.backgroundColor;
				backgroundColor.a = this.backgroundColor.a * o;
				this.displayBackground.color = backgroundColor;
			}
		}
		
		protected void SetStage(int stage) {
			this.nextStage = stage;
			if(this.nextStage != this.currentStage) {
				this.targetValue = 0f;
			}
		}
	}
}
