﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Units.Aim {
	public class TransformRaycastAim : AbstractUnitAim {
		public Transform aim;

		public Transform rotateY;
		public Transform rotateX;

		public float rotationSpeed = 10f;
		public LayerMask targetMask = ~0;
		public float targetDistance = 10f;

		protected RaycastHit hit;

		void Update() {
			if(this.inputRotate.sqrMagnitude > 0f) {	
				this.inputDirection = Quaternion.LookRotation(this.inputRotate * this.rotationSpeed * Time.deltaTime) * this.inputDirection;
			}

			if(this.rotateY != null) {
				Vector3 lookY = (new Vector3(this.inputDirection.x, 0f, this.inputDirection.z)).normalized;
				this.rotateY.rotation = Quaternion.LookRotation(lookY);
			}

			if(this.rotateX != null) {
				Vector3 lookX = (new Vector3(0f, this.inputDirection.y, 1f)).normalized;
				this.rotateX.rotation = Quaternion.LookRotation(lookX);
			}			

			/*if(this.inputRotate.sqrMagnitude > 0f) {
				this.aim.Rotate(this.inputRotate * Time.deltaTime, Space.Self);
			}*/

			if(Physics.Raycast(this.aim.position, this.aim.forward, out this.hit, this.targetDistance, this.targetMask, QueryTriggerInteraction.Collide)) {
				SetTarget(hit.collider.gameObject, hit.point);
			} else {
				SetTarget(null, this.aim.position + this.aim.forward * this.targetDistance);
			}
		}

		void OnDrawGizmos() {
			Vector3 origin = GetAimOrigin();

			Gizmos.color = Color.blue;
			Gizmos.DrawLine(origin, origin + GetAimDirection() * this.targetDistance);
		}

		public override Vector3 GetAimOrigin() {
			return this.aim.position;
		}

		public override Vector3 GetAimDirection() {
			return this.aim.forward;
		}
	}
}
