﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using MIGames.Units.Interactions;

namespace MIGames.Units.Input {
	public class StandardUnitInput : AbstractUnitInput {
		[Header("Interaction")]
		[Tooltip("Is interaction input enabled?")]
		public bool interactionEnabled = false;
		public string interactionButton = "Interact";

		protected InteractionHandler interaction;

		void Start() {
			if(this.target == null) this.target = this.transform;

			if(this.interaction == null) this.interaction = this.target.GetComponentInParent<InteractionHandler>();
			if(this.interaction == null) this.interactionEnabled = false;
		}

		void Update() {
			if(this.interactionEnabled) {
				if(CheckAction(this.interactionButton)) {
					this.interaction.Interact();
				}
			}
		}
		
		public override bool CheckAction(string action) {
			if(string.IsNullOrEmpty(action)) return false;
			return UnityEngine.Input.GetButtonDown(action);
		}
	}
}
