﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace MIGames.Units.Interactions {
	public class InteractionHandler : MonoBehaviour {
		public UnitAim aim;

		protected GameObject target;
		protected List<Interactable> interactables = new List<Interactable>();

		void Start() {
			if(this.aim == null) this.aim = GetComponent<UnitAim>();

			this.aim.onTargetChange += OnTargetChange;
		}

		void OnTargetChange(GameObject target) {
			this.target = target;

			this.interactables.Clear();
			if(target != null) this.interactables.AddRange(target.GetComponents<Interactable>());
		}

		public Interactable[] GetInteractables() {
			return this.interactables.ToArray();
		}

		public void Interact() {
			Debug.Log("InteractWith " + this.target);
			InteractWith(this.target);
		}

		public void InteractWith(GameObject target) {
			if(target == null) {
				return;
			}

			target.SendMessage("OnInteract", this.gameObject, SendMessageOptions.DontRequireReceiver);
		}
	}
}
