﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Units.Movement {
	public abstract class AbstractCharacterMovement : AbstractUnitMovement {
		[Header("General")]
		[Tooltip("Force applied downward when in the air")]
		public float gravityDownForce = 20f;
		[Tooltip("Physic layers checked to consider the player grounded")]
		public LayerMask groundCheckLayers = -1;
		[Tooltip("distance from the bottom of the character controller capsule to test for grounded")]
		public float groundCheckDistance = 0.05f;

		[Header("Movement")]
		[Tooltip("Max movement speed when grounded (when not sprinting)")]
		public float maxSpeedOnGround = 10f;
		[Tooltip("Sharpness for the movement when grounded, a low value will make the player accelerate and decelerate slowly, a high value will do the opposite")]
		public float movementSharpnessOnGround = 15;
		//[Tooltip("Max movement speed when crouching")]
		//[Range(0,1)]
		//public float maxSpeedCrouchedRatio = 0.5f;
		[Tooltip("Max movement speed when not grounded")]
		public float maxSpeedInAir = 10f;
		[Tooltip("Acceleration speed when in the air")]
		public float accelerationSpeedInAir = 25f;
		//[Tooltip("Multiplicator for the sprint speed (based on grounded speed)")]
		//public float sprintSpeedModifier = 2f;

		[Header("Rotation")]
		[Tooltip("Rotation speed for moving the camera")]
		public float rotationSpeed = 200f;

		[Header("Jump")]
		[Tooltip("Force applied upward when jumping")]
		public float jumpForce = 9f;

		[Header("Steps")]
		[Tooltip("Amount of footsteps when moving one meter")]
		public float footstepFrequency = 1f;
		//[Tooltip("Amount of footstep sounds played when moving one meter while sprinting")]
		//public float footstepFrequencyWhileSprinting = 1f;

		public Vector3 characterVelocity { get; set; }
		public bool isGrounded { get; protected set; }
		public bool hasJumpedThisFrame { get; protected set; }
		//public bool isDead { get; private set; }
		//public bool isCrouching { get; private set; }
		public float RotationMultiplier { get { return 1f; } }

		public UnityAction<float> onGroundEnter;
		public UnityAction onGroundExit;
		public UnityAction<float> onJump;
		public UnityAction<float> onStep;

		protected Vector3 groundNormal;
		protected Vector3 m_CharacterVelocity;
		protected Vector3 m_LatestImpactSpeed;
		protected float m_LastTimeJumped = 0f;
		//protected float m_CameraVerticalAngle = 0f;
		protected float m_footstepDistanceCounter;
		//protected float m_TargetCharacterHeight;

		protected const float k_JumpGroundingPreventionTime = 0.2f;
		protected const float k_GroundCheckDistanceInAir = 0.07f;

		protected virtual void Init() {
        	//UpdateCharacterHeight(true);
		}

		protected virtual void Process(float deltaTime) {
        	hasJumpedThisFrame = false;

		    bool wasGrounded = isGrounded;
		    GroundCheck();

		    // landing
		    if (isGrounded && !wasGrounded) {
				this.onGroundEnter.Invoke(-Mathf.Min(characterVelocity.y, m_LatestImpactSpeed.y));
		    } else if(!isGrounded && wasGrounded) {
				this.onGroundExit.Invoke();
			}

		    // crouching
		    //if (m_InputHandler.GetCrouchInputDown()) {
		    //    SetCrouchingState(!isCrouching, false);
		    //}

		    //UpdateCharacterHeight(false);

		    HandleCharacterMovement();
		}

		protected abstract void GroundCheck();
		protected abstract void HandleCharacterMovement();
	}
}
