﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace MIGames.Units {
	public class UnitAimIK : MonoBehaviour {
		public bool activated = true;

		public Animator animator;
		public UnitAim aim;		

		public float bodyWeight = 0.5f;
		public float headWeight = 1f;

		public Transform forward;
		public Transform weapon;
		public Transform weaponHand;

		void Start() {
			if(this.aim == null) {
				this.aim = GetComponentInParent<UnitAim>();
			}
			if(this.animator == null) {
				this.animator = GetComponent<Animator>();
			}
		}

		void OnDeath() {
			this.activated = false;
		}

		void OnRevive() {
			this.activated = true;
		}

		void OnAnimatorIK() {
			if(!this.activated) {
				return;
			}
			this.animator.SetLookAtPosition(this.aim.GetAimTargetPosition());
			this.animator.SetLookAtWeight(1f,this.bodyWeight,this.headWeight,0.5f);
		}

		void LateUpdate() {
			if(!this.activated) {
				return;
			}
			Quaternion handRotation = Quaternion.FromToRotation(this.aim.GetAimDirection(), weapon.forward);

			this.weaponHand.rotation *= handRotation;
		}
	}
}
