﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace MIGames.Units {
	public class UnitAnimator : MonoBehaviour {
		public UnitMovement movement;
		public Animator[] animators;
		public Transform forward;

		[Header("Movement")]
		[Tooltip("Is movement animating enabled?")]
		public bool movementEnabled = false;
		public string movementX = "";
		public string movementY = "";
		public string movementZ = "";
		public string rotationX = "";
		public string rotationY = "";
		public string rotationZ = "";

		void Start() {
			if(this.animators == null || this.animators.Length < 1) {
				this.animators = GetComponentsInChildren<Animator>();
			}

			if(this.forward == null) {
				this.forward = this.transform;
			}

			if(this.movement == null) {
				this.movement = GetComponentInParent<UnitMovement>();
			}
		}

		void Update() {
			if(this.movementEnabled) {
				UpdateMovement();
			}
		}

		protected void UpdateMovement() {
			Vector3 velocity = new Vector3();
			Vector3 angularVelocity = new Vector3();
			if(this.movement != null) {
				velocity = this.transform.InverseTransformDirection(this.movement.GetVelocity());
				angularVelocity = this.transform.InverseTransformDirection(this.movement.GetAngularVelocity());
			}

			SetFloat(this.movementX, velocity.x);
			SetFloat(this.movementY, velocity.y);
			SetFloat(this.movementZ, velocity.z);

			SetFloat(this.rotationX, angularVelocity.x);
			SetFloat(this.rotationY, angularVelocity.y);
			SetFloat(this.rotationZ, angularVelocity.z);
		}

		// --- helpers

		protected void SetTrigger(string param) {
			if(this.animators == null || string.IsNullOrEmpty(param)) {
				return;
			}
			foreach(Animator animator in this.animators) animator.SetTrigger(param);
		}

		protected void SetBool(string param, bool val) {
			if(this.animators == null || string.IsNullOrEmpty(param)) {
				return;
			}
			foreach(Animator animator in this.animators) animator.SetBool(param, val);
		}

		protected void SetFloat(string param, float val) {
			if(this.animators == null || string.IsNullOrEmpty(param)) {
				return;
			}
			foreach(Animator animator in this.animators) animator.SetFloat(param, val);
		}

		protected void SetInteger(string param, int val) {
			if(this.animators == null || string.IsNullOrEmpty(param)) {
				return;
			}
			foreach(Animator animator in this.animators) animator.SetInteger(param, val);
		}
	}
}
