using UnityEngine;
using UnityEngine.Events;
	
namespace MIGames.Weapons.Actions {
	public abstract class AbstractWeaponAction : MonoBehaviour, WeaponAction {
		public Transform aim;

		protected UnityAction onHit;
		protected UnityAction onPerform;
		protected UnityAction onPerformStart;
		protected UnityAction onPerformEnd;
		
		protected WeaponHitData currentHitData;
		
		public abstract bool CanPerform(WeaponTriggerData trigger);
		public abstract bool TryPerform(WeaponTriggerData trigger);
		public abstract bool IsPerforming();

		// --- (un)register event handlers
		
		public virtual void RegisterHitAction(UnityAction action) {
			this.onHit += action;
		}
		
		public virtual void UnregisterHitAction(UnityAction action) {
			this.onHit -= action;
		}
		
		public virtual void RegisterPerformAction(UnityAction action) {
			this.onPerform += action;
		}
		
		public virtual void UnregisterPerformAction(UnityAction action) {
			this.onPerform -= action;
		}
		
		public virtual void RegisterPerformStartAction(UnityAction action) {
			this.onPerformStart += action;
		}
		
		public virtual void UnregisterPerformStartAction(UnityAction action) {
			this.onPerformStart -= action;
		}
		
		public virtual void RegisterPerformEndAction(UnityAction action) {
			this.onPerformEnd += action;
		}
		
		public virtual void UnregisterPerformEndAction(UnityAction action) {
			this.onPerformEnd -= action;
		}

		// --- input/output
		
		public virtual WeaponHitData GetCurrentHitData() {
			return this.currentHitData;
		}

		public virtual void SetAim(Transform aim) {
			this.aim = aim;
		}

		public virtual Transform GetAim() {
			return this.aim != null ? this.aim : this.transform;
		}
		
		// --- internals

		protected virtual void TriggerHit(WeaponHitData data) {
			this.currentHitData = data;
			this.onHit.Invoke();
		}
	}
}
