using UnityEngine;
	
namespace MIGames.Weapons.Actions {
	public class RaycastWeaponAction : AbstractWeaponAction {
		public Transform muzzle;
		public LayerMask mask;
		public bool hitTriggers;
		public float force = 100f;
		public int casts = 1;
		public int puncture = 0;

		protected WeaponSpray spray;

		void Start() {
			this.spray = GetComponent<WeaponSpray>();
			if(this.spray != null) this.spray.SetAim(this.GetAim());
		}

		public override bool IsPerforming() { 
			return false; 
		}
		
		public override bool CanPerform(WeaponTriggerData trigger) {
			return true;
		}
		
		public override bool TryPerform(WeaponTriggerData trigger) {
			if(!CanPerform(trigger)) {
				return false;
			}

			if(this.onPerformStart != null) this.onPerformStart.Invoke();
			if(this.onPerform != null) this.onPerform.Invoke();
			if(this.onPerformEnd != null) this.onPerformEnd.Invoke();

			QueryTriggerInteraction triggerInteraction = this.hitTriggers ? QueryTriggerInteraction.Collide : QueryTriggerInteraction.Ignore;
			Ray ray;
			RaycastHit hit;		
			float force;	
			for(int c = 0; c < this.casts; c++) {
				ray = GetRay(trigger);
				force = this.force;
				for(int h = 0; h < this.puncture + 1; h++) {
					if(Physics.Raycast(ray, out hit, force, this.mask, triggerInteraction)) {
						// subtract hit distance loss from current force
						force = force - hit.distance;
						if(force < 0f) {
							break;
						}
				
						if(ValidateTarget(hit.collider)) {
							TriggerHit(new WeaponHitData(hit.point, ray.direction * force, hit.normal, hit.collider, hit.distance, this.gameObject, null));
						}/* else {
							h--;
							ray.origin = hit.point;
							continue;
						}*/

						ray.origin = hit.point;

						// subtract puncture loss from current force
						force = force - this.force / (this.puncture + 1);
						if(force < 0f) {
							break;
						}
					} else {
						break;
					}
				}
			}
			
			return true;
		}

		protected virtual bool ValidateTarget(Collider collider) {
			// TODO: implement external validators

			return !collider.transform.IsChildOf(this.transform) && !this.transform.IsChildOf(collider.transform);
		}
		
		protected Ray GetRay(WeaponTriggerData trigger) {
			Transform aim = GetAim();

			Ray ray = new Ray(
				aim.position,
				aim.forward
			);
			
			if(this.spray != null) {
				ray = this.spray.Modify(ray, trigger);
			}
			
			return ray;
		}

		public override Transform GetAim() {
			return this.aim != null ? this.aim : (this.muzzle != null ? this.muzzle : this.transform);
		}

		public override void SetAim(Transform aim) {
			base.SetAim(aim);
			if(this.spray != null) this.spray.SetAim(this.aim);
		}
	}
}
