using UnityEngine;

namespace MIGames.Weapons {
	public class Bullethole : MonoBehaviour {
		protected Bulletholes controller;

		protected bool spawned {get{ return this.controller != null && this.transform.parent != this.controller.transform; }}

		public void Spawn(Bulletholes controller) {
			this.controller = controller;
		}

		public void Despawn() {
			if(this.controller == null) {
				return;
			}
			this.transform.SetParent(this.controller.transform);
			this.transform.gameObject.SetActive(false);
		}

		void OnDespawn() {
			Despawn();
		}

		/*void OnDestroy() {
			if(this.spawned) {
				Debug.LogWarning(
					"Bullethole is destroyed along parent.\n" + 
					"Bullethole should always be managed by Bulletholes controller.\n" + 
					"Broadcast OnDespawn on the object to destroy before destroying it to fix this."
				);
			}
		}*/
	}
}
