using UnityEngine;
using UnityEngine.UI;

using MIGames.Weapons.Actions;
using MIGames.Weapons.Handlers;

namespace MIGames.Weapons.Demo {
	public class WeaponSprayDemo : MonoBehaviour {
		public WeaponHandler handler;

		public bool spread {get;set;}
		public bool movementInaccuracy {get;set;}
		public bool recoil {get;set;}
		
		/*public Color activeColor = Color.green;
		public Color inactiveColor = Color.red;
		
		public Transform spreadView;
		public Transform movementInaccuracyView;
		public Transform recoilView;
		
		public string spreadKey = "f1";
		public string movementInaccuracyKey = "f2";
		public string recoilKey = "f3";*/
		
		protected bool spreadEnabled;
		protected bool movementInaccuracyEnabled;
		protected bool recoilEnabled;
		
		protected GameObject current;
		
		void Update() {
			bool changed = this.spread != this.spreadEnabled || this.movementInaccuracy != this.movementInaccuracyEnabled || this.recoil != this.recoilEnabled;
			
			GameObject current = this.handler.GetActiveWeapon();
			if(current != this.current) {
				this.current = current;
				if(this.current != null) changed = true;
			}
			
			/*if(Input.GetKeyDown(this.spreadKey)) {
				this.spreadEnabled = !this.spreadEnabled;
				changed = true;
			}
			if(Input.GetKeyDown(this.movementInaccuracyKey)) {
				this.movementInaccuracyEnabled = !this.movementInaccuracyEnabled;
				changed = true;
			}
			if(Input.GetKeyDown(this.recoilKey)) {
				this.recoilEnabled = !this.recoilEnabled;
				changed = true;
			}*/
			
			if(changed) {
				if(this.current != null) ApplyTo(this.current.GetComponent<StandardWeaponSpray>());
				/*UpdateUI();*/
			}
		}

		/*public void SetSpread(bool enabled) {
			this.spread = enabled;
		}

		public void SetMovementInaccuracy(bool enabled) {
			this.movementInaccuracy = enabled;
		}

		public void SetRecoil(bool enabled) {
			this.recoil = enabled;
		}*/
		
		protected void ApplyTo(StandardWeaponSpray spray) {
			spray.spreadEnabled = this.spreadEnabled = this.spread;
			spray.movementInaccuracyEnabled = this.movementInaccuracyEnabled = this.movementInaccuracy;
			spray.recoilEnabled = this.recoilEnabled = this.recoil;
		}
		
		/*protected void UpdateUI() {
			UpdateView(this.spreadView, this.spreadEnabled);
			UpdateView(this.movementInaccuracyView, this.movementInaccuracyEnabled);
			UpdateView(this.recoilView, this.recoilEnabled);
		}
		
		protected void UpdateView(Transform view, bool enabled) {
			if(view == null) return;
			Color color = enabled ? this.activeColor : this.inactiveColor;
			foreach(Text text in view.GetComponentsInChildren<Text>()) text.color = new Color(color.r, color.g, color.b, text.color.a);
			foreach(TMPro.TextMeshProUGUI text in view.GetComponentsInChildren<TMPro.TextMeshProUGUI>()) text.color = new Color(color.r, color.g, color.b, text.color.a);
			foreach(Image image in view.GetComponentsInChildren<Image>()) image.color = new Color(color.r, color.g, color.b, image.color.a);
		}*/
	}
}
