using UnityEngine;
using UnityEngine.Events;
	
namespace MIGames.Weapons.Effects {
	public abstract class AbstractWeaponEffect : MonoBehaviour {
		public WeaponController controller;

		protected virtual void OnEnable() {
			WeaponController controller = GetController();
			if(controller != null) controller.RegisterHitAction(OnHit);
		}

		protected virtual void OnDisable() {
			WeaponController controller = GetController();
			if(controller != null) controller.UnregisterHitAction(OnHit);
		}

		protected virtual void OnHit() {
			ProcessHit(this.controller.GetCurrentHitData());
		}

		protected WeaponController GetController() {
			if(this.controller == null) {
				this.controller = GetComponentInParent<WeaponController>();
			}
			return this.controller;
		}

		protected abstract void ProcessHit(WeaponHitData hit);
	}
}
