using UnityEngine;
using MIGames.Utilities;

namespace MIGames.Weapons.FX {
	[System.Serializable]	
	public class WeaponVFXPrefab {
		public GameObject prefab;
		public int cacheSize = 5;
		public float duration = 2f;
		[Layer]
		public int layer = 0;

		protected GameObject parent;
		protected GameObject[] runtime;
		protected int pointer = 0;

		public void Load(GameObject parent) {
			this.parent = parent;
	
			SetupCache();
		}

		public void Unload() {
			ClearCache();
		}

		public void Trigger() {
			Trigger(this.parent.transform, this.parent.transform.position, this.parent.transform.rotation);
		}

		public void Trigger(Transform parent, Vector3 position, Quaternion rotation) {
			if(this.runtime == null || this.runtime.Length < 1) {
				return;
			}

			if(this.runtime[this.pointer] == null) {
				this.runtime[this.pointer] = CreateInstance();
			}

			this.runtime[this.pointer].SetActive(false);
			this.runtime[this.pointer].transform.parent = parent;
			this.runtime[this.pointer].layer = this.layer;
			this.runtime[this.pointer].transform.position = position;
			this.runtime[this.pointer].transform.rotation = rotation;
			this.runtime[this.pointer].SetActive(true);

			this.pointer++;
			if(this.pointer >= this.runtime.Length) {
				this.pointer = 0;
			}
		}

		protected void SetupCache() {
			ClearCache();

			if(this.prefab == null) {
				return;
			}
			
			this.runtime = new GameObject[this.cacheSize];
			for(int i = 0; i < this.runtime.Length; i++) {
				this.runtime[i] = CreateInstance();
			}	
		}

		protected void ClearCache() {
			this.pointer = 0;
			if(this.runtime == null) return;
			foreach(GameObject instance in this.runtime) {
				if(instance != null) GameObject.Destroy(instance);
			}
			this.runtime = null;
		}

		protected GameObject CreateInstance() {
			GameObject instance = (GameObject)GameObject.Instantiate(this.prefab);
			instance.SetActive(false);
			instance.layer = this.parent.layer;
			instance.transform.parent = this.parent.transform;
			instance.transform.localPosition = new Vector3();
			instance.transform.localEulerAngles = new Vector3();

			WeaponVFXInstance vfx = instance.AddComponent<WeaponVFXInstance>();
			vfx.parent = this.parent.transform;
			vfx.duration = this.duration;

			return instance;
		}
	}
}
