using UnityEngine;

namespace MIGames.Weapons.Stats {
	public class StandardHealth : MonoBehaviour, WeaponHitReceiver {
		public float health = 100f;
		public string deathMessage = "OnDeath";
		public string reviveMessage = "Reset";
		public bool broadcast = false;
	
		protected float currentHealth = 0f;

		void Start() {
			this.currentHealth = this.health;
		}

		public void RegisterHit(WeaponHitData data) {
			StandardWeaponStats stats = data.weapon.GetComponent<StandardWeaponStats>();
			if(stats == null) {
				return;
			}

			ModifyHealth(-stats.damage * data.vulnerability);
		}

		public void ModifyHealth(float modify) {
			SetHealth(this.currentHealth + modify);
		}

		public void SetHealth(float health) {
			float lastHealth = this.currentHealth;
			this.currentHealth = Mathf.Clamp(health, 0f, this.health);

			if(this.currentHealth <= 0f && lastHealth > 0f) {
				TriggerMessage(this.deathMessage);
			} else if(lastHealth <= 0f && this.currentHealth > 0f) {
				TriggerMessage(this.reviveMessage);
			}

		}

		protected void TriggerMessage(string msg) {
			if(string.IsNullOrEmpty(msg)) {
				return;			
			}	

			if(this.broadcast) {
				BroadcastMessage(msg, SendMessageOptions.DontRequireReceiver);
				return;
			}

			SendMessage(msg, SendMessageOptions.DontRequireReceiver);
	
		}
	}
}
