using UnityEngine;

namespace MIGames.Weapons.Triggers {
	public class ChargedTrigger : AbstractIntervalTrigger {
		protected bool triggered;
		protected float started = 0f;

		void Update() {
			if(!this.triggered) {
				return;
			}
			TriggerUpdate(false);
		}

		public override void Break() {
			if(this.triggered) {
				TriggerShotEnd();
			}

			this.started = 0f;
			this.triggered = false;
		}

		public override void TriggerStart() {
			this.triggered = true;
			this.started = GetTime();

			TriggerShotStart();
		}

		public override void TriggerEnd() {
			if(!this.triggered) {
				return;
			}

			TriggerShotEnd();

			TriggerUpdate(true);
		}

		protected void TriggerUpdate(bool forceShot) {
			float delta = GetTime() - this.started;
			float chargeDuration = 1f / this.rps;
			if(forceShot || delta >= chargeDuration) {
				float chargeTime = Mathf.Min(delta, chargeDuration);
				TriggerShot(new WeaponTriggerData(this.started + chargeTime, chargeTime / chargeDuration, 0, chargeTime, this));
				this.triggered = false;
			}
		}
	}
}
