using UnityEngine;

namespace MIGames.Weapons.Triggers {
	public class SingleTrigger : AbstractIntervalTrigger {
		public float triggerReset = 0.5f;

		protected bool doTrigger = false;

		public override void TriggerStart() {
			this.doTrigger = true;

			CancelInvoke("ResetTrigger");
			Invoke("ResetTrigger", this.triggerReset);
		}

		public override void TriggerEnd() {}

		public override void Break() {}

		void Update() {
			if(!this.doTrigger) {
				return;
			}

			if(IsReady()) {
				TriggerShotStart();
				TriggerShot(new WeaponTriggerData(GetTime(), 1f, 0, 0f, this));
				TriggerShotEnd();

				this.doTrigger = false;
				return;
			}	
		}

		void ResetTrigger() {
			this.doTrigger = false;
		}
	}
}
