using UnityEngine;
using UnityEngine.UI;

using MIGames.Weapons.Charges;

namespace MIGames.Weapons.UI {
	public class ProjectileWeaponUI : WeaponUI {
		public Text ammoCurrent;
		public Text ammoMax;
		public Text ammoStored;
		public Text ammoSum;

		protected ProjectileCharge charge;

		public override void Setup() {
			base.Setup();

			if(this.weapon == null) {
				this.charge = null;
				return;
			}

			this.charge = this.weapon.GetComponent<ProjectileCharge>();
			if(this.charge != null) {
				this.charge.RegisterChargeUpdateAction(OnChargeUpdate);
			}

			UpdateUI();
		}

		void OnChargeUpdate() {
			UpdateUI();
		}

		protected virtual void UpdateUI() {
			if(this.charge == null) {
				if(this.ammoCurrent != null) this.ammoCurrent.text = "";
				if(this.ammoMax != null) this.ammoMax.text = "";
				if(this.ammoStored != null) this.ammoStored.text = "";
				if(this.ammoSum != null) this.ammoSum.text = "";
				return;
			}

			if(this.ammoCurrent != null) this.ammoCurrent.text = Mathf.Floor(this.charge.GetCurrentCharges()) + "";
			if(this.ammoMax != null) this.ammoMax.text = Mathf.Floor(this.charge.maxCharges) + "";
			if(this.ammoStored != null) this.ammoStored.text = this.charge.infiniteStorage ? "-" : Mathf.Floor(this.charge.chargesStored) + "";
			if(this.ammoSum != null) this.ammoSum.text = this.charge.infiniteStorage ? "-" : (Mathf.Floor(this.charge.chargesStored + this.charge.GetCurrentCharges()) + "");
		}

		public override void SetColor(Color color) {
			base.SetColor(color);
		}
	}
}
