using UnityEngine;
using UnityEngine.Events;

namespace MIGames.Weapons {
	public struct WeaponTriggerData {
		public float time;
		public float charge;
		public int volleyIndex;
		public float volleyTime;
		public WeaponTrigger trigger;
		
		public WeaponTriggerData(float time, float power, int volleyIndex, float volleyTime, WeaponTrigger trigger) {
			this.time = time;
			this.charge = power;
			this.volleyIndex = volleyIndex;
			this.volleyTime = volleyTime;
			this.trigger = trigger;
		}
	}

	public interface WeaponTrigger {
		bool CanTrigger();
		void TriggerStart();
		void TriggerEnd();
		void Break();
		void SetWeight(float weight);
		void RegisterTriggerAction(UnityAction handler);
		void UnregisterTriggerAction(UnityAction handler);
		void RegisterTriggerStartAction(UnityAction handler);
		void UnregisterTriggerStartAction(UnityAction handler);
		void RegisterTriggerEndAction(UnityAction handler);
		void UnregisterTriggerEndAction(UnityAction handler);
		WeaponTriggerData GetCurrentTriggerData();
	}
}
